<?php
/* 
Переписать на запрос функции firstConnection, при переходе на restApi
*/

require "../Connections.php";

$sock = Login();
checkActionAccess($sock, "write");
if (strtoupper($_SERVER["REQUEST_METHOD"]) == "POST") {
   $content_type = isset($_SERVER["CONTENT_TYPE"]) ? $_SERVER["CONTENT_TYPE"] : "";
   if (stripos($content_type, "application/json") === false) {
      throw new Exception("Content-Type must be application/json");
   }

   $body = file_get_contents("php://input");
   $array = json_decode($body, true);
   if (!is_array($array)) {
      header("HTTP/1.1 400 Bad Request");
      die();
   }
   foreach ($array as $object) {
      if (isContainNull($object)) {
         header("HTTP/1.1 400 Bad Request");
         die();
      }
      $index = $object["index"];

      $name = $object["name"];
      ParamSetString($sock, "video.input.[" . $index . "].title1251", $name);
      ParamSetString($sock, "video.input.[" . $index . "].titleUtf", $name, false);

      $ip = $object["ip"];
      ParamSetString($sock, "video.input.[" . $index . "].ip", $ip);

      $portOnvif = $object["portOnvif"];
      ParamSetInt($sock, "video.input.[" . $index . "].portOnvif", $portOnvif);
      ParamSetInt($sock, "video.input.[" . $index . "].port2", $portOnvif);

      $username = $object["username"];
      ParamSetString($sock, "video.input.[" . $index . "].username", $username);

      $pass = $object["pass"];
      ParamSetString($sock, "video.input.[" . $index . "].cam_password", $pass);
      sleep(1);
      ParamSetInt($sock, "video.input.[" . $index . "].mediatype", 82);
      sleep(3);
      ParamSetInt($sock, "video.input.[" . $index . "].usetcp", 1);
      ParamSetInt($sock, "video.input.[" . $index . "].usetcp2", 1);
   }
} else {
   throw new Exception("Only POST or GET requests are allowed");
}
socket_close($sock);
